<?php

use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;
use common\widgets\Alert;
use yii\helpers\ArrayHelper;
use common\models\AdmissionPrefix;
use common\models\AdmissionSex;

$this->title = Yii::t('app', 'Sign Up');
$this->params['breadcrumbs'][] = $this->title;

$prefixList = ArrayHelper::map(AdmissionPrefix::find()->all(), 'id', 'prefix_th_full');
$sexList = ArrayHelper::map(AdmissionSex::find()->all(), 'id', 'sex_title');
?>
<div class="register-box">
    <div class="register-logo">
        <?= Html::encode($this->title) ?>
    </div>
    <!-- /.register-logo -->
    <div class="card">
        <div class="card-body register-card-body">
            <p class="register-box-msg">กรุณากรอกข้อมูลให้ครบถ้วน</p>

            <?php $form = ActiveForm::begin([
                'id' => 'signup-form',
                'layout' => 'horizontal',
                'fieldConfig' => [
                    'horizontalCssClasses' => [
                        'label' => 'col-sm-4',
                        'wrapper' => 'col-sm-8',
                    ],
                ],
            ]); ?>
            <?= $form->field($model, 'identification_number')->textInput([
                'maxlength' => 13,
                'placeholder' => 'เลขบัตรประชาชน 13 หลัก'
            ]) ?>
            <?= $form->field($model, 'dateofbirth')->input('date') ?>
            <?= $form->field($model, 'id_admission_prefix')->dropDownList($prefixList, ['prompt' => '-- เลือกคำนำหน้า --']) ?>
            <?= $form->field($model, 'first_name')->textInput([
                'maxlength' => 255,
                'placeholder' => 'ชื่อ'
            ]) ?>
            <?= $form->field($model, 'last_name')->textInput([
                'maxlength' => 255,
                'placeholder' => 'นามสกุล'
            ]) ?>
            <?= $form->field($model, 'id_admission_sex')->dropDownList($sexList, ['prompt' => '-- เลือกเพศ --']) ?>
            <!--begin::Row-->
            <div class="row">
                <div class="col-8">
                    <div class="form-check">
                        <?= $form->field($model, 'terms', [
                            'horizontalCssClasses' => [
                                'wrapper' => '',
                                'label' => '',
                                'offset' => '',
                            ]
                        ])->checkbox(['class' => 'form-check-input', 'id' => 'flexCheckDefault'])->label('I agree to the ' . Html::a(Yii::t('app', 'terms'), ['site/terms'])) ?>
                    </div>
                </div>
                <!-- /.col -->
                <div class="col-4">
                    <div class="d-grid gap-2">
                        <?= Html::submitButton('ลงทะเบียน', ['class' => 'btn btn-primary']) ?>
                    </div>
                </div>
                <!-- /.col -->
            </div>
            <!--end::Row-->
            <?php ActiveForm::end(); ?>
            <p class="mb-0">
                <?= Html::a(Yii::t('app', 'I already have a membership'), ['login'], ['class' => 'text-center']) ?>
            </p>
        </div>
        <!-- /.register-card-body -->
    </div>
</div>