<?php

use common\models\AdmissionType;
use yii\helpers\Html;

$this->title = Yii::t('app', 'Home Page');
$model = AdmissionType::find()->all();
?>
<div class="row">
    <div class="col-sm-8">
        <div class="card card-outline card-primary mb-3">
            <div class="card-header">
                <h4 class="card-title"><?= Yii::t('app', 'Welcome to admission page') ?></h4>
            </div>
            <div class="card-body">
                <p><?= Yii::t('app', 'This is the admission management system for the school. Here you can find information about various admission types available for prospective students. Please explore the options and choose the one that best fits your educational goals.') ?></p>
                <?= Yii::$app->session->get('thai_id', '') ?>
            </div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="card card-outline card-primary mb-4">
            <div class="card-header">
                <h3 class="card-title"><?= Yii::t('app', 'The school has {count} admission types available for applicants.', ['count' => count($model)]) ?></h3>
            </div>
            <div class="card-body p-0">
                <?php

                echo Html::ul($model, [
                    'class' => 'list-group list-group-flush',
                    'item' => function ($item) {
                        return Html::tag('li', Html::encode($item->title), ['class' => 'list-group-item']);
                    },
                ]);
                ?>
            </div>
        </div>
    </div>
</div>