<?php

namespace  admission\models;

use common\models\AdmissionStudent;
use Yii;

/**
 * This is the model class for table "admission_student".
 *
 * @property int $id
 * @property string $first_name
 * @property string $last_name
 * @property string $first_name_en
 * @property string $last_name_en
 * @property string $email
 * @property int $learning_area_id
 * @property string|null $picture
 *
 * @property CurriculumSubjectTeacher[] $curriculumSubjectTeachers
 * @property CurriculumSubject[] $curriculumSubjects
 */
class User extends AdmissionStudent implements \yii\web\IdentityInterface
{

    /**
     * {@inheritdoc}
     */
    public static function findIdentityByAccessToken($token, $type = null)
    {
        return null;
    }

    /**
     * Finds user by username
     *
     * @param string $username
     * @return static|null
     */
    public static function findByUsername($username)
    {
        return self::findOne(['email' => $username]);
    }

    /**
     * {@inheritdoc}
     */
    public static function findIdentity($id)
    {
        return self::findOne($id);
    }

    /**
     * {@inheritdoc}
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * {@inheritdoc}
     */
    public function getAuthKey()
    {
        return $this->id;
    }

    /**
     * {@inheritdoc}
     */
    public function validateAuthKey($authKey)
    {
        return $this->id === $authKey;
    }
}
