<?php

namespace admission\controllers;

use admission\models\AdmissionSearch;
use admission\models\Registration;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use common\models\AdmissionStudent;

/**
 * Site controller
 */
class RegistrationController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['logout', 'signup'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {
        // check if user is already logged in
        if (!Yii::$app->user->isGuest) {
           return $this->redirect(['admission']);
        }

        // create form for create thai id
        $model = new Registration();
        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            \yii::$app->session->set('thai_id', $model->thai_id);
        }

        // check if user has a pending registration
        if (\yii::$app->session->get('thai_id', false) != false) {
            // check if student already exists
            $existingStudent = AdmissionStudent::find()->where(['identification_number' => $model->thai_id])->exists();
            if (!$existingStudent) {
                return $this->redirect(['site/signup']);
            }else{
                return $this->redirect(['site/login']);
            }
        }

        return $this->render('index', ['model' => $model]);
    }

    public function actionAdmission()
    {
        $searchModel = new AdmissionSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        return $this->render('admission', [
            'dataProvider' => $dataProvider,
            'searchModel' => $searchModel,
        ]);
    }
}
